#include "ledit.h"

#ifdef WIN32
#define COMMAND_CODE LOWORD(wParam)
#else
#define COMMAND_CODE wParam
#endif

static int DlgCount = 0;      // Number of currently open dialogs
static HINSTANCE hInst;
static void far* Buffer [4]; // Buffer to store block pointers

void Behaviour(HWND Wnd)
{
#include "ledit__s.inc"
}


// Dialog function
#pragma argsused
int CALLBACK _export LDlgProc(HWND  Wnd,
			      UINT  Msg,
			      WPARAM  wParam,
			      LPARAM lParam)
{
  switch ( Msg )
    {
      case WM_INITDIALOG:
       	{
          Behaviour(GetDlgItem(Wnd,101));

	  if ( DlgCount > 0)
	    {
	      // If this is not first dialog then fill in LEdit control
              // with text stored in the buffer by previous dialog-instance
	      SendDlgItemMessage(Wnd,101,EM_SETTEXT,EMP_ALLTEXT,
	        (LONG) Buffer[DlgCount-1]);
	    }

          // Increase number of dialogs
	  DlgCount++;

          // Disable OK button if this is fourth dialog
	  EnableWindow(GetDlgItem(Wnd,IDOK),DlgCount < 4);

          // Set default focus
	  return 1;
        }
      case WM_COMMAND:
        {
      	  switch ( COMMAND_CODE )
	    {
	      case IDOK:
	        {
                  // If nothing is selected then select all the text
		  LEDITPOSITION Pos;
		  SendDlgItemMessage(Wnd,101,EM_GETSEL,0,(LONG) &Pos);
		  if ( ((Pos.StartLine == Pos.EndLine) &&
		    (Pos.StartPosition == Pos.EndPosition)) )
		    SendDlgItemMessage(Wnd,101,WM_COMMAND,
		      EC_EDITSELECTALL,0L);

                  // Allocate global memory block to store selected text
                  // !!! Errors checking should be added
		  Buffer[DlgCount-1] = GlobalLock(GlobalAlloc(GMEM_MOVEABLE,
		    SendDlgItemMessage(Wnd,101,EM_GETSELTEXTLENGTH,0,0L)+1));

                  // Fill in the block with currently selected text
		  SendDlgItemMessage(Wnd,101,EM_GETSELTEXT,0,
		    (LONG) Buffer[DlgCount-1]);

		  // Start new dialog-instance, which will load our text at
                  // the WM_INITDIALOG
		  DialogBox(hInst,"DIALOG",Wnd,(DLGPROC) LDlgProc);

                  // Replace old text by the text supplied by dialog
		  SendDlgItemMessage(Wnd,101,EM_REPLACESEL,0,
		    (LONG) Buffer[DlgCount-1]);

                  // Free global memory block
		  HANDLE hMem = GlobalHandle(
#ifdef WIN32
          Buffer[DlgCount-1]
#else
		    HIWORD((DWORD)Buffer[DlgCount-1])
#endif
                                   );
		  GlobalUnlock(hMem);
		  GlobalFree(hMem);
                  break;
                }
	      case IDCANCEL:
	        {
		  if (DlgCount > 1)
		    {
                      // Free old memory block
		      HANDLE hMem = GlobalHandle(
#ifdef WIN32
              Buffer[DlgCount-1]
#else
		        HIWORD((DWORD)Buffer[DlgCount-1])
#endif
                                       );
		      GlobalUnlock(hMem);
		      GlobalFree(hMem);

                      // Allocate new one instead with appropriate size
		      Buffer[DlgCount-2] = GlobalLock(GlobalAlloc
		        (GMEM_MOVEABLE,SendDlgItemMessage
		        (Wnd,101,EM_GETTEXTLENGTH,EMP_ALLTEXT,0L)+1));

		      // Fill in the block with text from LEdit control
		      // it will replace selection in the previous dialog-
                      // instance
		      SendDlgItemMessage(Wnd,101,EM_GETTEXT,EMP_ALLTEXT,
		        (LONG) Buffer[DlgCount-2]);
		    }

                  // Close dialog
		  SendMessage(Wnd,WM_CLOSE,0,0L);
                  break;
                }
            }
          break;
        }
      case WM_CLOSE:
	{
          // Decrease number of dialogs
	  DlgCount--;

          // End dialog
	  EndDialog(Wnd,0);
          break;
        }
    }
return 0;
}

// Main Windows function
#pragma argsused
int PASCAL WinMain (HINSTANCE hInstance,
		    HINSTANCE hPrevInst,
		    LPSTR     lpszCmdLine,
		    int       nCmdShow)

{
  // To ensure static loading of LEDIT.DLL
  LVer();

  // Set constant
  hInst = hInstance;

  // Call first dialog
  DialogBox(hInstance,"DIALOG",0,(DLGPROC) LDlgProc);

  return 0;
}